/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MeltingEffect
extends ContinuousEffectImpl {
    MeltingEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "All lands are no longer snow";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private MeltingEffect(MeltingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MeltingEffect copy() {
        return new MeltingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game)) {
            permanent.removeSuperType(game, SuperType.SNOW);
        }
        return true;
    }
}

