/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MemoryVesselExileEffect
extends OneShotEffect {
    MemoryVesselExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles the top seven cards of their library. Until your next turn, players may play cards they exiled this way";
    }

    private MemoryVesselExileEffect(MemoryVesselExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public MemoryVesselExileEffect copy() {
        return new MemoryVesselExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            Set cards = player.getLibrary().getTopCards(game, 7);
            player.moveCards(cards, Zone.EXILED, source, game);
            for (Card card : cards) {
                CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilYourNextTurn, (boolean)false, (UUID)playerId, null);
            }
        }
        return true;
    }
}

