/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CantBeTargetedSourceEffect;
import mage.abilities.effects.common.PutOnLibraryTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterObject;
import mage.filter.FilterPermanent;
import mage.filter.FilterStackObject;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class MercenaryInformer
extends CardImpl {
    private static final FilterObject filterBlack = new FilterStackObject("black spells or abilities from black sources");
    private static final FilterPermanent filterMercenary = new FilterPermanent("nontoken Mercenary");

    public MercenaryInformer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.REBEL);
        this.subtype.add((Object)SubType.MERCENARY);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CantBeTargetedSourceEffect(filterBlack, Duration.WhileOnBattlefield)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new PutOnLibraryTargetEffect(false), (Cost)new ManaCostsImpl("{2}{W}"));
        ability.addTarget((Target)new TargetPermanent(filterMercenary));
        this.addAbility((Ability)ability);
    }

    private MercenaryInformer(MercenaryInformer card) {
        super((CardImpl)card);
    }

    public MercenaryInformer copy() {
        return new MercenaryInformer(this);
    }

    static {
        filterBlack.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
        filterMercenary.add((Predicate)TokenPredicate.FALSE);
        filterMercenary.add((Predicate)SubType.MERCENARY.getPredicate());
    }
}

