/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class MeriekeRiBeritDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    MeriekeRiBeritDelayedTriggeredAbility() {
        super((Effect)new DestroyTargetEffect(true), Duration.Custom, true);
    }

    private MeriekeRiBeritDelayedTriggeredAbility(MeriekeRiBeritDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE || event.getType() == GameEvent.EventType.UNTAPPED;
    }

    public boolean isInactive(Game game) {
        return this.getSourceObjectIfItStillExists(game) == null && game.getLastKnownInformation(this.getSourceId(), Zone.BATTLEFIELD, this.getStackMomentSourceZCC()) == null;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId() != null && event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.getSourceId())) {
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            return zEvent.getFromZone() == Zone.BATTLEFIELD;
        }
        return GameEvent.EventType.UNTAPPED == event.getType() && event.getTargetId() != null && event.getTargetId().equals(this.getSourceId());
    }

    public MeriekeRiBeritDelayedTriggeredAbility copy() {
        return new MeriekeRiBeritDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When {this} leaves the battlefield or becomes untapped, destroy that creature. It can't be regenerated.";
    }
}

