/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class MerryEsquireOfRohanTriggeredAbility
extends TriggeredAbilityImpl {
    MerryEsquireOfRohanTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.setTriggerPhrase("Whenever you attack with {this} and another legendary creature, ");
    }

    private MerryEsquireOfRohanTriggeredAbility(MerryEsquireOfRohanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MerryEsquireOfRohanTriggeredAbility copy() {
        return new MerryEsquireOfRohanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.getSourceId())) return false;
        if (!game.getCombat().getAttackers().stream().filter(uuid -> !this.getSourceId().equals(uuid)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isLegendary(game)).anyMatch(permanent -> permanent.isCreature(game))) return false;
        return true;
    }
}

