/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MessengerJaysEffect
extends OneShotEffect {
    MessengerJaysEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for feather or quill. Put a +1/+1 counter on {this} for each feather vote and draw a card for each quill vote. For each card drawn this way, discard a card.";
    }

    private MessengerJaysEffect(MessengerJaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public MessengerJaysEffect copy() {
        return new MessengerJaysEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Feather (+1/+1 counter)", "Quill (draw a card)", Outcome.Benefit);
        vote.doVotes(source, game);
        int featherCount = vote.getVoteCount((Object)true);
        int quillCount = vote.getVoteCount((Object)false);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (featherCount > 0 && permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(featherCount), source.getControllerId(), source, game);
        }
        Player player = game.getPlayer(source.getControllerId());
        if (quillCount > 0 && player != null) {
            int drawn = player.drawCards(quillCount, source, game);
            player.discard(drawn, false, false, source, game);
        }
        return featherCount + quillCount > 0;
    }
}

