/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MetamorphicAlterationEffect
extends ContinuousEffectImpl {
    MetamorphicAlterationEffect() {
        super(Duration.WhileOnBattlefield, Layer.CopyEffects_1, SubLayer.CopyEffects_1a, Outcome.Copy);
        this.staticText = "Enchanted creature is a copy of the chosen creature.";
    }

    private MetamorphicAlterationEffect(MetamorphicAlterationEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        Permanent copied = (Permanent)game.getState().getValue(source.getSourceId().toString() + "CHOSEN_CREATURE");
        if (enchantment == null || copied == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        permanent.setName(copied.getName());
        permanent.getManaCost().clear();
        permanent.getManaCost().addAll((Collection)copied.getManaCost());
        CardUtil.copySetAndCardNumber((MageObject)permanent, (MageObject)copied);
        permanent.removeAllCardTypes(game);
        for (SuperType t : copied.getSuperType(game)) {
            permanent.addSuperType(game, t);
        }
        permanent.removeAllCardTypes(game);
        for (CardType cardType : copied.getCardType(game)) {
            permanent.addCardType(game, new CardType[]{cardType});
        }
        permanent.removeAllSubTypes(game);
        permanent.copySubTypesFrom(game, (MageObject)copied);
        permanent.getColor(game).setColor(copied.getColor(game));
        permanent.removeAllAbilities(source.getSourceId(), game);
        for (Ability ability : copied.getAbilities()) {
            permanent.addAbility(ability, source.getSourceId(), game, true);
        }
        permanent.getPower().setModifiedBaseValue(copied.getPower().getBaseValue());
        permanent.getToughness().setModifiedBaseValue(copied.getToughness().getBaseValue());
        return true;
    }

    public MetamorphicAlterationEffect copy() {
        return new MetamorphicAlterationEffect(this);
    }
}

