/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class MetamorphoseEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("artifact, creature, enchantment, or land card");

    public MetamorphoseEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "That opponent may put an artifact, creature, enchantment, or land card from their hand onto the battlefield.";
    }

    private MetamorphoseEffect(MetamorphoseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            Player controller = game.getPlayer(permanent.getControllerId());
            if (controller != null && controller.canRespond() && controller.chooseUse(Outcome.PutCardInPlay, "Put an artifact, creature, enchantment, or land card onto the battlefield?", source, game)) {
                Card card;
                TargetCardInHand target = new TargetCardInHand(filter);
                target.clearChosen();
                if (controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }

    public MetamorphoseEffect copy() {
        return new MetamorphoseEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

