/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.AddConditionalManaOfAnyColorEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.m.MetamorphosisManaBuilder;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MetamorphosisEffect
extends OneShotEffect {
    MetamorphosisEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "Add X mana of any one color, where X is 1 plus the sacrificed creature's mana value. Spend this mana only to cast creature spells.";
    }

    private MetamorphosisEffect(MetamorphosisEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
            amount = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getManaValue() + 1;
            break;
        }
        if (amount > 0) {
            new AddConditionalManaOfAnyColorEffect(amount, (ConditionalManaBuilder)new MetamorphosisManaBuilder()).apply(game, source);
        }
        return false;
    }

    public MetamorphosisEffect copy() {
        return new MetamorphosisEffect(this);
    }
}

