/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MeteorCraterEffect
extends ManaEffect {
    public MeteorCraterEffect() {
        this.staticText = "Choose a color of a permanent you control. Add one mana of that color";
    }

    private MeteorCraterEffect(MeteorCraterEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        return game == null ? new ArrayList<Mana>() : ManaType.getManaListFromManaTypes(this.getManaTypes(game, source), (boolean)true);
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Set<ManaType> types = this.getManaTypes(game, source);
        if (types.isEmpty()) {
            return null;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return null;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(types, (boolean)true);
        if (choice.getChoices().size() == 1) {
            choice.setChoice((String)choice.getChoices().iterator().next());
        } else if (!player.choose(Outcome.PutManaInPool, choice, game)) {
            return null;
        }
        ManaType chosenType = ManaType.findByName((String)choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType);
    }

    private Set<ManaType> getManaTypes(Game game, Ability source) {
        HashSet<ManaType> types = new HashSet<ManaType>(5);
        if (game == null) {
            return types;
        }
        List controlledPermanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), game);
        for (Permanent permanent : controlledPermanents) {
            ObjectColor color = permanent.getColor(game);
            if (color.isBlack()) {
                types.add(ManaType.BLACK);
            }
            if (color.isBlue()) {
                types.add(ManaType.BLUE);
            }
            if (color.isGreen()) {
                types.add(ManaType.GREEN);
            }
            if (color.isRed()) {
                types.add(ManaType.RED);
            }
            if (color.isWhite()) {
                types.add(ManaType.WHITE);
            }
            if (types.size() != 5) continue;
            break;
        }
        return types;
    }

    public MeteorCraterEffect copy() {
        return new MeteorCraterEffect(this);
    }
}

