/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MezzioMuggerEffect
extends OneShotEffect {
    MezzioMuggerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of each player's library. You may play those cards this turn, and you may spend mana as though it were mana of any color to cast those spells";
    }

    private MezzioMuggerEffect(MezzioMuggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MezzioMuggerEffect copy() {
        return new MezzioMuggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getLibrary).map(library -> library.getFromTop(game)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards(cards, Zone.EXILED, source, game);
        for (Card card : cards) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        return true;
    }
}

