/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.ShuffleHandGraveyardIntoLibraryEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MidnightClockTriggeredAbility
extends TriggeredAbilityImpl {
    MidnightClockTriggeredAbility() {
        super(Zone.ALL, (Effect)new ShuffleHandGraveyardIntoLibraryEffect(), false);
        this.addEffect((Effect)new DrawCardSourceControllerEffect(7).concatBy(", then"));
        this.addEffect((Effect)new ExileSourceEffect());
        this.setTriggerPhrase("When the twelfth hour counter is put on {this}, ");
    }

    private MidnightClockTriggeredAbility(MidnightClockTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId()) || !event.getData().equals(CounterType.HOUR.getName())) {
            return false;
        }
        int amountAdded = event.getAmount();
        Permanent sourcePermanent = Optional.ofNullable(game.getPermanent(this.getSourceId())).orElse(game.getPermanentEntering(this.getSourceId()));
        int hourCounters = sourcePermanent != null ? sourcePermanent.getCounters(game).getCount(CounterType.HOUR) : amountAdded;
        return hourCounters - amountAdded < 12 && 12 <= hourCounters;
    }

    public MidnightClockTriggeredAbility copy() {
        return new MidnightClockTriggeredAbility(this);
    }
}

