/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.choices.VillainousChoice;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MidnightCrusaderShuttleSecondChoice
extends VillainousChoice {
    MidnightCrusaderShuttleSecondChoice() {
        super("you gain control of a creature of your choice that player controls until end of turn. If you gain control of a creature this way, tap it, and it's attacking that player", "{controller} gains control of one of your creatures and it attacks you");
    }

    public boolean doChoice(Player player, Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game, 1)) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature defending player controls");
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        controller.choose(Outcome.GainControl, (Target)target, source, game);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        game.addEffect(new GainControlTargetEffect(Duration.EndOfTurn, true).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.processAction();
        if (!permanent.isControlledBy(controller.getId())) {
            return false;
        }
        permanent.tap(source, game);
        game.getCombat().addAttackingCreature(permanent.getId(), game, player.getId());
        return true;
    }
}

