/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MilesTailsProwerEffect
extends OneShotEffect {
    MilesTailsProwerEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if it has flying. Otherwise, put a flying counter on it";
    }

    private MilesTailsProwerEffect(MilesTailsProwerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MilesTailsProwerEffect copy() {
        return new MilesTailsProwerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanent == null) {
            return false;
        }
        if (permanent.hasAbility((Ability)FlyingAbility.getInstance(), game)) {
            return Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> player.drawCards(1, source, game) > 0).isPresent();
        }
        return Optional.ofNullable(this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source)).filter(p -> p.addCounters(CounterType.FLYING.createInstance(), source, game)).isPresent();
    }
}

