/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.m.MimeoPlasmReveredOneCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class MimeoplasmReveredOneEffect
extends OneShotEffect {
    public MimeoplasmReveredOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a copy of target creature card exiled with it, except it's 0/0 and has this ability.";
    }

    public MimeoplasmReveredOneEffect(MimeoplasmReveredOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public MimeoplasmReveredOneEffect copy() {
        return new MimeoplasmReveredOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mimeoplasm = game.getPermanent(source.getSourceId());
        if (controller == null || mimeoplasm == null) {
            return false;
        }
        Card chosen = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (chosen == null) {
            return false;
        }
        PermanentCard newBluePrint = new PermanentCard(chosen, source.getControllerId(), game);
        newBluePrint.assignNewId();
        MimeoPlasmReveredOneCopyApplier applier = new MimeoPlasmReveredOneCopyApplier();
        applier.apply(game, (MageObject)newBluePrint, source, mimeoplasm.getId());
        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, mimeoplasm.getId());
        copyEffect.setApplier((CopyApplier)applier);
        copyEffect.init(source.copy(), game);
        game.addEffect((ContinuousEffect)copyEffect, source);
        return true;
    }
}

