/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class MimeoplasmReveredOneEntersEffect
extends OneShotEffect {
    MimeoplasmReveredOneEntersEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to X creature cards from your graveyard. It enters with three +1/+1 counters on it for each creature card exiled this way";
    }

    private MimeoplasmReveredOneEntersEffect(MimeoplasmReveredOneEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public MimeoplasmReveredOneEntersEffect copy() {
        return new MimeoplasmReveredOneEntersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mimeoplasm = game.getPermanentEntering(source.getSourceId());
        if (controller == null || controller.getGraveyard().isEmpty() || mimeoplasm == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue == 0) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, xValue, (FilterCard)StaticFilters.FILTER_CARD_CREATURES);
        target.withNotTarget(true);
        if (!controller.chooseTarget(Outcome.Exile, (Target)target, source, game)) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID targetId : target.getTargets()) {
            cards.add(controller.getGraveyard().get(targetId, game));
        }
        int zcc = CardUtil.getActualSourceObjectZoneChangeCounter((Game)game, (Ability)source);
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)zcc);
        if (!controller.moveCardsToExile(cards.getCards(game), source, game, true, exileId, CardUtil.getSourceName((Game)game, (Ability)source))) {
            return false;
        }
        int counters = cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) * 3;
        mimeoplasm.addCounters(CounterType.P1P1.createInstance(counters), controller.getId(), source, game);
        return true;
    }
}

