/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SpellAbilityType;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class MinamosMeddlingCounterTargetEffect
extends OneShotEffect {
    MinamosMeddlingCounterTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. That spell's controller reveals their hand, then discards each card with the same name as a card spliced onto that spell";
    }

    private MinamosMeddlingCounterTargetEffect(MinamosMeddlingCounterTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public MinamosMeddlingCounterTargetEffect copy() {
        return new MinamosMeddlingCounterTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Spell spell = game.getStack().getSpell(targetId);
            if (spell == null) continue;
            game.getStack().counter(targetId, source, game);
            Player spellController = game.getPlayer(spell.getControllerId());
            if (spellController == null) continue;
            spellController.revealCards(sourceObject.getName(), spellController.getHand(), game);
            CardsImpl cardsToDiscard = new CardsImpl();
            for (SpellAbility spellAbility : spell.getSpellAbilities()) {
                if (spellAbility.getSpellAbilityType() != SpellAbilityType.SPLICE) continue;
                for (Card card : spellController.getHand().getCards(game)) {
                    if (!card.getName().equals(spellAbility.getCardName())) continue;
                    cardsToDiscard.add(card);
                }
            }
            if (cardsToDiscard.isEmpty()) continue;
            spellController.discard((Cards)cardsToDiscard, false, source, game);
        }
        return true;
    }
}

