/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class MinasTirithWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    MinasTirithWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            this.map.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((MinasTirithWatcher)game.getState().getWatcher(MinasTirithWatcher.class)).map.getOrDefault(source.getControllerId(), 0) >= 2;
    }
}

