/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MindGrindEffect
extends OneShotEffect {
    MindGrindEffect() {
        super(Outcome.Discard);
        this.staticText = "Each opponent reveals cards from the top of their library until they reveal X land cards, then puts all cards revealed this way into their graveyard. X can't be 0";
    }

    private MindGrindEffect(MindGrindEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindGrindEffect copy() {
        return new MindGrindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue < 1) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(opponentId);
            if (player == null) continue;
            int landsToReveal = xValue;
            CardsImpl cards = new CardsImpl();
            for (Card card : player.getLibrary().getCards(game)) {
                cards.add(card);
                if (!card.isLand(game) || --landsToReveal != 0) continue;
                break;
            }
            player.revealCards(source, "from " + player.getName(), (Cards)cards, game);
            player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

