/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetDiscard;

class MindMaggotsEffect
extends OneShotEffect {
    MindMaggotsEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "discard any number of creature cards. For each card discarded this way, put two +1/+1 counters on {this}";
    }

    private MindMaggotsEffect(MindMaggotsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindMaggotsEffect copy() {
        return new MindMaggotsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetDiscard target = new TargetDiscard(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, controller.getId());
        controller.choose(this.outcome, controller.getHand(), (TargetCard)target, source, game);
        int counters = controller.discard((Cards)new CardsImpl((Collection)target.getTargets()), false, source, game).size() * 2;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || counters < 1) {
            return true;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(counters), source.getControllerId(), source, game);
        return true;
    }
}

