/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.ComparisonType;
import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class MindlinkMechWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> crewCount = new HashMap<MageObjectReference, Integer>();
    private static final FilterPermanent invalidFilter = new FilterPermanent();

    MindlinkMechWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.VEHICLE_CREWED) {
            Permanent vehicle = game.getPermanent(event.getTargetId());
            this.crewCount.compute(new MageObjectReference((MageObject)vehicle, game), (m, i) -> i == null ? 1 : Integer.sum(i, 1));
        }
    }

    public void reset() {
        super.reset();
        this.crewCount.clear();
    }

    public static boolean checkVehicle(Ability source, Game game) {
        return ((MindlinkMechWatcher)game.getState().getWatcher(MindlinkMechWatcher.class)).crewCount.getOrDefault(new MageObjectReference(source), 0) < 2;
    }

    static {
        invalidFilter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, -2));
    }
}

