/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MindsDilationEffect
extends OneShotEffect {
    MindsDilationEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "that player exiles the top card of their library. If it's a nonland card, you may cast it without paying its mana cost";
    }

    private MindsDilationEffect(MindsDilationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindsDilationEffect copy() {
        return new MindsDilationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && sourceObject != null && opponent != null) {
            Card card;
            if (opponent.getLibrary().hasCards() && (card = opponent.getLibrary().getFromTop(game)) != null && opponent.moveCards(card, Zone.EXILED, source, game) && !card.isLand(game) && controller.chooseUse(this.outcome, "Cast " + card.getLogName() + " without paying its mana cost from exile?", source, game)) {
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
            }
            return true;
        }
        return false;
    }
}

