/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.util.CardUtil;

class MindspliceApparatusEffect
extends CostModificationEffectImpl {
    MindspliceApparatusEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "instant and sorcery spells you cast cost {1} less to cast for each oil counter on {this}";
    }

    private MindspliceApparatusEffect(MindspliceApparatusEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int amount = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(permanent -> permanent.getCounters(game)).map(counters -> counters.getCount(CounterType.OIL)).orElse(0);
        if (amount < 1) {
            return false;
        }
        CardUtil.adjustCost((SpellAbility)((SpellAbility)abilityToModify), (int)amount);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        Card sourceCard = game.getCard(abilityToModify.getSourceId());
        return sourceCard != null && abilityToModify.isControlledBy(source.getControllerId()) && sourceCard.isInstantOrSorcery(game);
    }

    public MindspliceApparatusEffect copy() {
        return new MindspliceApparatusEffect(this);
    }
}

