/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MineWorkerEffect
extends OneShotEffect {
    MineWorkerEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain 1 life. If you control creatures named Power Plant Worker and Tower Worker, you gain 3 life instead.";
    }

    private MineWorkerEffect(MineWorkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MineWorkerEffect copy() {
        return new MineWorkerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        String powerPlantName = "Power Plant Worker";
        String towerName = "Tower Worker";
        boolean powerPlant = false;
        boolean tower = false;
        int life = 1;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
            String name = permanent.getName();
            if (!powerPlant && powerPlantName.equals(name)) {
                powerPlant = true;
            } else if (!tower && towerName.equals(name)) {
                tower = true;
            }
            if (!powerPlant || !tower) continue;
            life = 3;
            break;
        }
        controller.gainLife(life, game, source);
        return true;
    }
}

