/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.token.TreasureAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MinimusContainmentEffect
extends ContinuousEffectImpl {
    private static final Ability ability = new TreasureAbility(false);

    MinimusContainmentEffect() {
        super(Duration.WhileOnBattlefield, Outcome.LoseAbility);
        this.staticText = "enchanted permanent is a Treasure artifact with \"{T}, Sacrifice this artifact: Add one mana of any color,\" and it loses all other abilities";
    }

    private MinimusContainmentEffect(MinimusContainmentEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MinimusContainmentEffect copy() {
        return new MinimusContainmentEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent aura = source.getSourcePermanentIfItStillExists(game);
        if (aura == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(aura.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.retainAllArtifactSubTypes(game);
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                permanent.addSubType(game, new SubType[]{SubType.TREASURE});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                permanent.addAbility(ability, source.getSourceId(), game);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

