/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MinionLeshracEffect
extends OneShotEffect {
    MinionLeshracEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "{this} deals 5 damage to you unless you sacrifice a creature other than {this}. If {this} deals damage to you this way, tap it";
    }

    private MinionLeshracEffect(MinionLeshracEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent minionLeshrac = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && minionLeshrac != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);
            if (controller.chooseUse(Outcome.AIDontUseIt, "Sacrifice another creature to prevent the damage?", source, game) && cost.canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), true)) {
                return true;
            }
            if (controller.damage(5, minionLeshrac.getId(), source, game) > 0) {
                minionLeshrac.tap(source, game);
                return true;
            }
        }
        return false;
    }

    public MinionLeshracEffect copy() {
        return new MinionLeshracEffect(this);
    }
}

