/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.common.CreaturesYouControlHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

public final class MinionsMurmurs
extends CardImpl {
    public MinionsMurmurs(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{B}{B}");
        this.getSpellAbility().addEffect((Effect)new MinionsMurmursEffect());
        this.getSpellAbility().addHint((Hint)CreaturesYouControlHint.instance);
    }

    private MinionsMurmurs(MinionsMurmurs card) {
        super((CardImpl)card);
    }

    public MinionsMurmurs copy() {
        return new MinionsMurmurs(this);
    }

    static class MinionsMurmursEffect
    extends OneShotEffect {
        public MinionsMurmursEffect() {
            super(Outcome.DrawCard);
            this.staticText = "You draw X cards and you lose X life, where X is the number of creatures you control";
        }

        private MinionsMurmursEffect(MinionsMurmursEffect effect) {
            super((OneShotEffect)effect);
        }

        public MinionsMurmursEffect copy() {
            return new MinionsMurmursEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                int creaturesControlled = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game);
                controller.drawCards(creaturesControlled, source, game);
                controller.loseLife(creaturesControlled, game, source, false);
                return true;
            }
            return false;
        }
    }
}

