/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.target.common.TargetControlledCreaturePermanent;

class MinscBooTimelessHeroesEffect
extends OneShotEffect {
    MinscBooTimelessHeroesEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice a creature. When you do, {this} deals X damage to any target, where X is that creature's power. If the sacrificed creature was a Hamster, draw X cards";
    }

    private MinscBooTimelessHeroesEffect(MinscBooTimelessHeroesEffect effect) {
        super((OneShotEffect)effect);
    }

    public MinscBooTimelessHeroesEffect copy() {
        return new MinscBooTimelessHeroesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        int power = permanent.getPower().getValue();
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(power), false, "deals X damage to any target, where X is that creature's power. If the sacrificed creature was a Hamster, draw X cards");
        if (permanent.hasSubtype(SubType.HAMSTER, game)) {
            ability.addEffect((Effect)new DrawCardSourceControllerEffect(power));
        }
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

