/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MirageMirrorCopyEffect
extends OneShotEffect {
    MirageMirrorCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of target artifact, creature, enchantment, or land until end of turn";
    }

    private MirageMirrorCopyEffect(MirageMirrorCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirageMirrorCopyEffect copy() {
        return new MirageMirrorCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            game.copyPermanent(Duration.EndOfTurn, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            return true;
        }
        return false;
    }
}

