/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAttackingCreature;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MirkwoodTrapperEffect
extends OneShotEffect {
    MirkwoodTrapperEffect() {
        super(Outcome.BoostCreature);
        this.setText("that player chooses an attacking creature. It gets +2/+0 until end of turn");
    }

    private MirkwoodTrapperEffect(MirkwoodTrapperEffect ability) {
        super((OneShotEffect)ability);
    }

    public MirkwoodTrapperEffect copy() {
        return new MirkwoodTrapperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        TargetAttackingCreature target = new TargetAttackingCreature(1, 1, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (player != null) {
            game.informPlayers(player.getLogName() + " chose " + permanent.getLogName() + ".");
        }
        BoostTargetEffect boost = new BoostTargetEffect(2, 0);
        boost.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)boost, source);
        return true;
    }
}

