/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MirrorBoxBoostEffect
extends ContinuousEffectImpl {
    MirrorBoxBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "each nontoken creature you control gets +1/+1 for each other creature you control with the same name as that creature";
    }

    private MirrorBoxBoostEffect(MirrorBoxBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MirrorBoxBoostEffect copy() {
        return new MirrorBoxBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN, source.getControllerId(), source, game)) {
            int amount = this.getAmount(permanents, permanent, game);
            permanent.addPower(amount);
            permanent.addToughness(amount);
        }
        return true;
    }

    private int getAmount(List<Permanent> permanents, Permanent target, Game game) {
        return permanents.stream().filter(permanent -> !permanent.getId().equals(target.getId()) && CardUtil.haveSameNames((MageObject)permanent, (MageObject)target)).mapToInt(x -> 1).sum();
    }
}

