/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MirrorGolemImprintEffect
extends OneShotEffect {
    MirrorGolemImprintEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile target card from a graveyard";
    }

    private MirrorGolemImprintEffect(MirrorGolemImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorGolemImprintEffect copy() {
        return new MirrorGolemImprintEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null) {
                if (sourcePermanent != null) {
                    UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourcePermanent.getZoneChangeCounter(game));
                    String exileZoneName = sourcePermanent.getIdName();
                    controller.moveCardsToExile(card, source, game, true, exileZoneId, exileZoneName);
                    sourcePermanent.imprint(this.getTargetPointer().getFirst(game, source), game);
                } else {
                    controller.moveCardsToExile(card, source, game, true, null, "");
                }
            }
            return true;
        }
        return false;
    }
}

