/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MirrorMarchEffect
extends OneShotEffect {
    MirrorMarchEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin until you lose a flip. For each flip you won, create a token that's a copy of that creature. Those tokens gain haste. Exile them at the beginning of the next end step.";
    }

    private MirrorMarchEffect(MirrorMarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorMarchEffect copy() {
        return new MirrorMarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int counter = 0;
        boolean wonFlip = false;
        do {
            if (!(wonFlip = player.flipCoin(source, game, true))) continue;
            ++counter;
        } while (wonFlip);
        if (counter > 0) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(player.getId(), null, true, counter);
            effect.setUseLKI(true);
            effect.setTargetPointer(this.getTargetPointer().copy());
            effect.apply(game, source);
            effect.exileTokensCreatedAtNextEndStep(game, source);
        }
        return true;
    }
}

