/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.common.CopySpellForEachItCouldTargetEffect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class MirrorwingDragonCopySpellEffect
extends CopySpellForEachItCouldTargetEffect {
    MirrorwingDragonCopySpellEffect() {
        this.staticText = "that player copies that spell for each other creature they control that the spell could target. Each copy targets a different one of those creatures.";
    }

    private MirrorwingDragonCopySpellEffect(MirrorwingDragonCopySpellEffect effect) {
        super((CopySpellForEachItCouldTargetEffect)effect);
    }

    protected Player getPlayer(Game game, Ability source) {
        Spell spell = this.getStackObject(game, source);
        if (spell == null) {
            return null;
        }
        return game.getPlayer(spell.getControllerId());
    }

    protected List<MageObjectReferencePredicate> prepareCopiesWithTargets(StackObject stackObject, Player player, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        return game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game).stream().filter(Objects::nonNull).filter(p -> !p.equals(permanent)).filter(p -> stackObject.canTarget(game, p.getId())).map(p -> new MageObjectReference((MageObject)p, game)).map(MageObjectReferencePredicate::new).collect(Collectors.toList());
    }

    protected Spell getStackObject(Game game, Ability source) {
        return (Spell)this.getValue("triggeringSpell");
    }

    public MirrorwingDragonCopySpellEffect copy() {
        return new MirrorwingDragonCopySpellEffect(this);
    }
}

