/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.m.MirrorwingDragonCopySpellEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.util.TargetAddress;

class MirrorwingDragonCopyTriggeredAbility
extends TriggeredAbilityImpl {
    MirrorwingDragonCopyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MirrorwingDragonCopySpellEffect(), false);
    }

    private MirrorwingDragonCopyTriggeredAbility(MirrorwingDragonCopyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MirrorwingDragonCopyTriggeredAbility copy() {
        return new MirrorwingDragonCopyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return this.checkSpell(spell, game);
    }

    private boolean checkSpell(Spell spell, Game game) {
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        boolean noTargets = true;
        for (TargetAddress addr : TargetAddress.walk((Card)spell)) {
            if (addr == null) continue;
            noTargets = false;
            Target targetInstance = addr.getTarget(spell);
            if (targetInstance == null) continue;
            for (UUID target : targetInstance.getTargets()) {
                Permanent permanent;
                if (target == null || (permanent = game.getPermanent(target)) != null && permanent.getId().equals(this.getSourceId())) continue;
                return false;
            }
        }
        if (noTargets) {
            return false;
        }
        this.getEffects().setValue("triggeringSpell", (Object)spell);
        return true;
    }

    public String getRule() {
        return "Whenever a player casts an instant or sorcery spell that targets only {this}, that player copies that spell for each other creature they control that the spell could target. Each copy targets a different one of those creatures.";
    }
}

