/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MisersCageTriggeredAbility
extends TriggeredAbilityImpl {
    MisersCageTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2), false);
    }

    private MisersCageTriggeredAbility(MisersCageTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MisersCageTriggeredAbility copy() {
        return new MisersCageTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (player = game.getPlayer(event.getPlayerId())) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
            }
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        Player player = game.getPlayer(game.getActivePlayerId());
        return player != null && player.getHand().size() >= 5;
    }

    public String getRule() {
        return "at the beginning of each opponent's upkeep, if that player has five or more cards in hand, {this} deals 2 damage to that player.";
    }
}

