/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.RogueToken;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class MisfortuneTellerEffect
extends OneShotEffect {
    MisfortuneTellerEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target card from a graveyard. If it was a creature card, create a 2/2 black Rogue creature token. If it was a land card, create a Treasure token. Otherwise, you gain 3 life.";
    }

    private MisfortuneTellerEffect(MisfortuneTellerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MisfortuneTellerEffect copy() {
        return new MisfortuneTellerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        if (card == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean creature = card.isCreature(game);
        boolean land = card.isLand(game);
        if (!controller.moveCards(card, Zone.EXILED, source, game)) {
            return false;
        }
        if (creature) {
            new RogueToken().putOntoBattlefield(1, game, source);
        }
        if (land) {
            new TreasureToken().putOntoBattlefield(1, game, source);
        }
        if (!creature && !land) {
            controller.gainLife(3, game, source);
        }
        return true;
    }
}

