/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class MishraArtificerProdigyEffect
extends OneShotEffect {
    private String cardName;

    MishraArtificerProdigyEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search your graveyard, hand, and/or library for a card named <i>" + this.cardName + "</i> and put it onto the battlefield. If you search your library this way, shuffle.";
    }

    private MishraArtificerProdigyEffect(MishraArtificerProdigyEffect effect) {
        super((OneShotEffect)effect);
        this.cardName = effect.cardName;
    }

    public MishraArtificerProdigyEffect copy() {
        return new MishraArtificerProdigyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInYourGraveyard target;
            FilterCard filter = new FilterCard("card named " + this.cardName);
            filter.add((Predicate)new NamePredicate(this.cardName));
            Card card = null;
            if (controller.chooseUse(Outcome.Neutral, "Search your graveyard?", source, game)) {
                target = new TargetCardInYourGraveyard(1, 1, filter);
                if (controller.choose(Outcome.PutCardInPlay, (Cards)controller.getGraveyard(), (TargetCard)target, source, game)) {
                    card = game.getCard(target.getFirstTarget());
                }
            }
            if (card == null && controller.chooseUse(Outcome.Neutral, "Search your hand?", source, game)) {
                target = new TargetCardInHand(0, 1, filter);
                if (controller.choose(Outcome.PutCardInPlay, controller.getHand(), (TargetCard)target, source, game)) {
                    card = game.getCard(target.getFirstTarget());
                }
            }
            if (card == null && controller.chooseUse(Outcome.Neutral, "Search your library?", source, game)) {
                target = new TargetCardInLibrary(0, 1, filter);
                if (controller.searchLibrary((TargetCardInLibrary)target, source, game)) {
                    card = game.getCard(target.getFirstTarget());
                }
                controller.shuffleLibrary(source, game);
            }
            if (card != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }

    public void setName(String cardName) {
        this.cardName = cardName;
    }
}

