/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class MishraEminentOneEffect
extends OneShotEffect {
    MishraEminentOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of target noncreature artifact you control, except its name is Mishra's Warform and it's a 4/4 Construct artifact creature in addition to its other types. It gains haste until end of turn. Sacrifice it at the beginning of the next end step";
    }

    private MishraEminentOneEffect(MishraEminentOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public MishraEminentOneEffect copy() {
        return new MishraEminentOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect().setPermanentModifier(token -> {
            token.setName("Mishra's Warform");
            token.setPower(4);
            token.setToughness(4);
            token.addCardType(new CardType[]{CardType.ARTIFACT, CardType.CREATURE});
            token.addSubType(new SubType[]{SubType.CONSTRUCT});
        });
        effect.apply(game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game)), source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

