/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MishrasWarMachineEffect
extends OneShotEffect {
    MishrasWarMachineEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "{this} deals 3 damage to you unless you discard a card. If it deals damage to you this way, tap it";
    }

    private MishrasWarMachineEffect(MishrasWarMachineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            DiscardCardCost cost = new DiscardCardCost();
            if (controller.chooseUse(Outcome.Benefit, "Discard a card to prevent the damage?", source, game) && cost.canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), true)) {
                return true;
            }
            if (controller.damage(3, sourcePermanent.getId(), source, game) > 0) {
                sourcePermanent.tap(source, game);
                return true;
            }
        }
        return false;
    }

    public MishrasWarMachineEffect copy() {
        return new MishrasWarMachineEffect(this);
    }
}

