/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MissionBriefingEffect
extends OneShotEffect {
    MissionBriefingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Surveil 2, then choose an instant or sorcery card in your graveyard. You may cast it this turn. If that spell would be put into your graveyard, exile it instead.";
    }

    private MissionBriefingEffect(MissionBriefingEffect effect) {
        super((OneShotEffect)effect);
    }

    public MissionBriefingEffect copy() {
        return new MissionBriefingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.surveil(2, source, game);
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY_FROM_YOUR_GRAVEYARD);
        player.choose(this.outcome, (Target)target, source, game);
        MayCastTargetCardEffect effect = new MayCastTargetCardEffect(Duration.EndOfTurn, true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
        effect.apply(game, source);
        return true;
    }
}

