/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesChosenCreatureTypeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MistformMaskEffect
extends OneShotEffect {
    MistformMaskEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Enchanted creature becomes the creature type of your choice until end of turn.";
    }

    private MistformMaskEffect(MistformMaskEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePerm = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePerm == null) {
            return false;
        }
        Permanent enchantedPerm = game.getPermanent(sourcePerm.getAttachedTo());
        if (enchantedPerm == null) {
            return false;
        }
        BecomesChosenCreatureTypeTargetEffect effect = new BecomesChosenCreatureTypeTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(enchantedPerm, game));
        return effect.apply(game, source);
    }

    public MistformMaskEffect copy() {
        return new MistformMaskEffect(this);
    }
}

