/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MizziumTransreliquatCopyEffect
extends OneShotEffect {
    MizziumTransreliquatCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of target artifact until end of turn";
    }

    private MizziumTransreliquatCopyEffect(MizziumTransreliquatCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MizziumTransreliquatCopyEffect copy() {
        return new MizziumTransreliquatCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            game.copyPermanent(Duration.EndOfTurn, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            return true;
        }
        return false;
    }
}

