/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class MizzixsMasteryOverloadEffect
extends OneShotEffect {
    MizzixsMasteryOverloadEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile each card that's an instant or sorcery from your graveyard. For each card exiled this way, copy it, and you may cast the copy without paying its mana cost";
    }

    private MizzixsMasteryOverloadEffect(MizzixsMasteryOverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public MizzixsMasteryOverloadEffect copy() {
        return new MizzixsMasteryOverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Set cardsToExile = controller.getGraveyard().getCards((FilterCard)new FilterInstantOrSorceryCard(), source.getControllerId(), source, game);
            if (!cardsToExile.isEmpty() && controller.moveCards(cardsToExile, Zone.EXILED, source, game)) {
                CardsImpl copiedCards = new CardsImpl();
                for (Card card : cardsToExile) {
                    copiedCards.add(game.copyCard(card, source, source.getControllerId()));
                }
                boolean continueCasting = true;
                while (controller.canRespond() && continueCasting && !copiedCards.isEmpty()) {
                    TargetCard targetCard = new TargetCard(0, 1, Zone.EXILED, new FilterCard("copied card to cast without paying its mana cost?"));
                    targetCard.withNotTarget(true);
                    if (controller.chooseTarget(Outcome.PlayForFree, (Cards)copiedCards, targetCard, source, game)) {
                        Card selectedCard = game.getCard(targetCard.getFirstTarget());
                        if (selectedCard != null && selectedCard.getSpellAbility().canChooseTarget(game, controller.getId())) {
                            game.getState().setValue("PlayFromNotOwnHandZone" + selectedCard.getId(), (Object)Boolean.TRUE);
                            controller.cast(controller.chooseAbilityForCast(selectedCard, game, true), game, true, new ApprovingObject(source, game));
                            game.getState().setValue("PlayFromNotOwnHandZone" + selectedCard.getId(), null);
                        }
                        copiedCards.remove(selectedCard);
                    }
                    continueCasting = !copiedCards.isEmpty() && controller.chooseUse(Outcome.Benefit, "Continue to choose copies and cast?", source, game);
                }
            }
            return true;
        }
        return false;
    }
}

