/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainControlAllUntapGainHasteEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;

public final class MobRule
extends CardImpl {
    private static final FilterPermanent filter4orMore = new FilterCreaturePermanent("creatures with power 4 or greater");
    private static final FilterPermanent filter3orLess = new FilterCreaturePermanent("creatures with power 3 or less");

    public MobRule(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{4}{R}{R}");
        this.getSpellAbility().addEffect((Effect)new GainControlAllUntapGainHasteEffect(filter4orMore).withTextOptions("those creatures"));
        this.getSpellAbility().addMode(new Mode((Effect)new GainControlAllUntapGainHasteEffect(filter3orLess).withTextOptions("those creatures")));
    }

    private MobRule(MobRule card) {
        super((CardImpl)card);
    }

    public MobRule copy() {
        return new MobRule(this);
    }

    static {
        filter4orMore.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
        filter3orLess.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 4));
    }
}

