/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ManaSpentToCastCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyPermanentEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.util.functions.CopyApplier;

class MockingbirdEffect
extends OneShotEffect {
    MockingbirdEffect() {
        super(Outcome.Benefit);
        this.staticText = "as a copy of any creature on the battlefield with mana value less than or equal to the amount of mana spent to cast {this}, except it's a Bird in addition to its other types and it has flying.";
    }

    private MockingbirdEffect(MockingbirdEffect effect) {
        super((OneShotEffect)effect);
    }

    public MockingbirdEffect copy() {
        return new MockingbirdEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int manaSpent = ManaSpentToCastCount.instance.calculate(game, source, (Effect)this);
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature on the battlefield with mana value less than or equal to the amount of mana spent to cast Mockingbird");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, manaSpent));
        CopyPermanentEffect copyEffect = new CopyPermanentEffect((FilterPermanent)filter, new CopyApplier(){

            public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
                blueprint.addSubType(new SubType[]{SubType.BIRD});
                blueprint.getAbilities().add((Object)FlyingAbility.getInstance());
                return true;
            }
        });
        return copyEffect.apply(game, source);
    }
}

