/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class MoggAssassinEffect
extends OneShotEffect {
    MoggAssassinEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "You choose target creature an opponent controls, and that opponent chooses target creature. Flip a coin. If you win the flip, destroy the creature you chose. If you lose the flip, destroy the creature your opponent chose";
    }

    private MoggAssassinEffect(MoggAssassinEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoggAssassinEffect copy() {
        return new MoggAssassinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent chosenPermanent = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent opponentsPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (controller.flipCoin(source, game, true)) {
            if (chosenPermanent != null) {
                chosenPermanent.destroy(source, game, false);
                return true;
            }
        } else if (opponentsPermanent != null) {
            opponentsPermanent.destroy(source, game, false);
            return true;
        }
        return false;
    }
}

