/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MoltenPrimordialEffect
extends OneShotEffect {
    MoltenPrimordialEffect() {
        super(Outcome.GainControl);
        this.staticText = "for each opponent, gain control of up to one target creature that player controls until end of turn. Untap those creatures. They gain haste until end of turn";
    }

    private MoltenPrimordialEffect(MoltenPrimordialEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoltenPrimordialEffect copy() {
        return new MoltenPrimordialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (Target target : source.getTargets()) {
            Permanent targetCreature;
            if (!(target instanceof TargetCreaturePermanent) || (targetCreature = game.getPermanent(target.getFirstTarget())) == null) continue;
            GainControlTargetEffect effect1 = new GainControlTargetEffect(Duration.EndOfTurn);
            effect1.setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getId(), game));
            game.addEffect((ContinuousEffect)effect1, source);
            GainAbilityTargetEffect effect2 = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
            effect2.setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getId(), game));
            game.addEffect((ContinuousEffect)effect2, source);
            targetCreature.untap(game);
            result = true;
        }
        return result;
    }
}

