/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.SpellsCastWatcher;

class MonkClassCastEffect
extends AsThoughEffectImpl {
    MonkClassCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "you may cast this card from exile as long as you've cast another spell this turn";
    }

    private MonkClassCastEffect(MonkClassCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        UUID mainCardId = CardUtil.getMainCardId((Game)game, (UUID)sourceId);
        if (!mainCardId.equals(source.getSourceId()) || !source.isControlledBy(affectedControllerId)) {
            return false;
        }
        Card card = game.getCard(sourceId);
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        return card != null && watcher != null && !card.isLand(game) && watcher.getCount(affectedControllerId) > 0;
    }

    public MonkClassCastEffect copy() {
        return new MonkClassCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }
}

