/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.Card;
import mage.cards.m.MonkClassCastEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MonkClassEffect
extends OneShotEffect {
    MonkClassEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. For as long as it remains exiled, it has \"You may cast this card from exile as long as you've cast another spell this turn.\"";
    }

    private MonkClassEffect(MonkClassEffect effect) {
        super((OneShotEffect)effect);
    }

    public MonkClassEffect copy() {
        return new MonkClassEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        game.addEffect(new GainAbilityTargetEffect((Ability)new SimpleStaticAbility(Zone.EXILED, (Effect)new MonkClassCastEffect()), Duration.Custom, null, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        return true;
    }
}

